<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateToolsCategoriesCardinalityForIsvp extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'tools_categories',
            fieldName: 'tools_categories_listings',
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools_categories',
            fieldName: 'tools_categories_listings',
            options:[
                'name' => 'tools_categories_listings',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Listing catégorie d\'outils',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['tools_categories_listings'],
                    'cardinality' => 1,
                ],
            ],
            weight: -3
        );
        Artisan::call('models:rebuild');
    }
}
