<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Services\QuickAccessService;

class AddDefaultTool extends Migration
{
    public function up(): void
    {
        $defaultTools = [
            'Semana' => 0,
            'Feedback Intranet' => 1,
            'Demande de support' => 2,
        ];

        $defaultToolsCategory = 'Informatique';

        $existingTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title])
            ->pluck('title')
            ->toArray();

        $toolsToCreate = array_diff(array_keys($defaultTools), $existingTools);

        $toolsCategory = ToolsCategories::where('title', $defaultToolsCategory)->first();

        $bridge = new BridgeContent();

        if (!$toolsCategory) {
            $bridge->contentUpdate(
                type: 'tools_categories',
                data: [
                    'title' => $defaultToolsCategory,
                    'weight' => 1,
                ]
            );
        }

        collect($toolsToCreate)->each(function ($title) use ($bridge, $defaultTools, $toolsCategory) {
            $bridge->contentUpdate(
                type: 'tools',
                data: [
                    'title' => $title,
                    'weight' => $defaultTools[$title],
                    'tools_categories' => [
                        'target_uuid' => $toolsCategory->uuid,
                    ],
                ]
            );
        });

        $bridgeContentType = new BridgeContentType();

        $allTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title]);

        $defaultToolsUuids = $allTools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        $quickAccesService = new QuickAccessService();
        $quickAccesService->cleanUnpublishedTools();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );

        Users::with('tools')->get()->each(function ($user) use ($bridge, $defaultToolsUuids) {
            $currentTools = $user->tools
                    ->pluck('uuid_host')
                    ->toArray();

            $defaultToolsUuidsExtracted = array_map(function ($item) {
                return $item['target_uuid'];
            }, $defaultToolsUuids);

            $uniqueToolsUuids = array_values(array_unique(array_merge($currentTools, $defaultToolsUuidsExtracted)));

            $uniqueTools = array_map(function ($uuid) {
                return ['target_uuid' => $uuid];
            }, $uniqueToolsUuids);

            $bridge->updateReferenceFields(
                type: 'users',
                contentUuidHost: $user->uuid_host,
                data: [
                        'tools' => $uniqueTools
                    ]
            );
        });
    }
}
