<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeSearchableSkillsForIsvp extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'skill',
            options: [
                'name' => 'skill',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Compétence',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 12,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 12
        );

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild --type=users');
    }
}
