<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class IsvpUpdateContentAttr extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'tabs_pages' => ['permissible' => true, 'searchable'  => true, 'global_searchable'  => true],
            'tabs' => ['permissible' => true],
            'spaces_pages' => ['permissible' => true],
            'pages_categories' => ['permissible' => true]
        ]);

        $contentTypes->each(function ($options, $contentType) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $contentType,
                options: $options
            );
        });

        Artisan::call('models:rebuild');
    }
}
