<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddColorFieldInContentTypes extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $contentTypes = collect([
            'pages',
            'tools_categories_listings',
        ]);

        $contentTypes->each(function ($type) use ($bridgeContentType) {
            $bridgeContentType->contentTypeCreateOrUpdateField(
                type: $type,
                fieldName: 'color',
                options: [
                    'name' => 'color',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 4,
                    'title' => [
                        'fr' => 'Couleur du titre de la page',
                        'en' => 'Page title color',
                        'es' => 'Color del título de la página',
                        'pt' => 'Cor do título da página',
                        'de' => 'Farbe des Seitentitels',
                        'nl' => 'Kleur van de paginatitel',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                        'settings' => [],
                        'weight' => 4,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ]
            );
        });
    }
}
