<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

class MakeUserReferencesMultiple extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        collect(['companies','sites','departments','services','managers','activities'])
            ->each(fn (string $reference) => $this->getBridge()?->switchCardinalityFromUnaryToMultiple(
                'users',
                $reference,
                true
            ));
        $this->call('models:rebuild');
        $this->finishUp();
    }
}
