<?php

use Illuminate\Support\Facades\Storage;
use Inside\Support\Str;
use Inside\User\Models\User;

return [
    'files' => [
        'isvp' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/import.xlsx'),
            'fields' => [
                'email' => 'mail',
                'name' => 'mail',
                'firstname' => 'prénom',
                'lastname' => 'nom',
                'mobile_phone' => 'téléphone mobile',
                'phone' => 'téléphone fixe',
                'function' => 'intitulé de poste',
                'skill' => 'compétences',
                'image' => function (mixed $record) {
                    $basename = $record['mail'];
                    $ext = '.jpg';
                    $imagePath = 'photos/' . $basename . $ext;
                    if (!Storage::disk('local')->exists($imagePath)) {
                        $ext = '.png';
                        $imagePath = 'photos/' . $basename . $ext;
                        if (!Storage::disk('local')->exists($imagePath)) {
                            return User::query()->where('email', $record['mail'])->first()?->image;
                        }
                    }

                    $fileName = Str::uuid() . $ext;
                    $chunkId = Str::random(32);
                    $chunkPath = "chunks/images/$chunkId/$fileName";

                    Storage::makeDirectory("chunks/images/$chunkId");
                    Storage::disk('local')->copy($imagePath, $chunkPath);

                    return $chunkPath;
                },
                'is_manager' => fn (mixed $record) => (bool) $record['est manager'],
                'companies' => fn (mixed $record) => reference('companies')
                    ->identifiedBy('code')
                    ->from($record['société'])
                    ->get(),
                'sites' => fn (mixed $record) => reference('sites')
                    ->identifiedBy('code')
                    ->from($record['site'])
                    ->get(),
                'departments' => fn (mixed $record) => reference('departments')
                    ->identifiedBy('code')
                    ->from($record['département'])
                    ->get(),
                'services' => fn (mixed $record) => reference('services')
                    ->identifiedBy('code')
                    ->from($record['service'])
                    ->get(),
                'activities' => fn (mixed $record) => reference('activities')
                    ->identifiedBy('code')
                    ->from($record['activité'])
                    ->get(),
                'managers' => fn (mixed $record) => reference('users')
                    ->identifiedBy('email')
                    ->from($record['adresse mail du manager'])
                    ->withoutCreation()
                    ->first(),

                'status' => fn () => true,
            ],
            'original_fields' => [
                'prénom' => 'firstname',
                'nom' => 'lastname',
                'mail' => 'email',
                'téléphone fixe' => 'phone',
                'téléphone mobile' => 'phone',
                'intitulé de poste' => 'word',
                'société' => 'company',
                'site' => 'word',
                'département' => 'word',
                'service' => 'word',
                'activité' => 'word',
                'adresse mail du manager' => 'email',
                'est manager' => 'number',
                'compétences' => 'word'
            ],
        ],
    ],
];
