import FullNewsE2E from '@inside-news/tests-e2e/class/FullNewsE2E'

export default class _FullNewsE2E extends FullNewsE2E {
  constructor(props) {
    super(props)

    this.steps = [
      'before',
      'goOnNewsPage',
      'checkClass',
      'checkTitle',
      'checkCategories',
      'checkComments',
      'checkOtherNews',
      'cleanup'
    ]
  }

  checkCategories() {
    it('Check categories', () => {
      const categoriesLength = this.newsData[0].news_categories.data.length

      cy.get('.full-news-container')
        .find('.categories .item')
        .should('have.length', categoriesLength)
    })
  }
}
