import JobSpacePage from '../pages/spaces/JobSpacePage'
import JobPage from '../pages/spaces/JobPage'
import { fetchJobSpacePage, fetchJobPage } from '../components/spaces/spaces'

import { ROUTE_NAMES as EVENT_ROUTE_NAMES } from '@inside-events/constants'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      extraFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: { linkTypes: null }
  },
  {
    name: 'JobSpacePage',
    path: '/espace/:slug',
    component: withFetch(JobSpacePage, { size: 'xxl' })(fetchJobSpacePage)
  },
  {
    name: 'JobPage',
    path: '/page-metier/:slug',
    component: withFetch(JobPage, { size: 'xxl' })(fetchJobPage)
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      contentOptions: {
        scaffoldOverrides: (fields, { addItemBefore }) => {
          addItemBefore('picture', {
            id: 'chapo',
            class: 'full-news-chapo',
            tag: 'p',
            value: fields.chapo,
            html: true
          })
        }
      }
    }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'JobSpacePage',
    path: '/espace/:slug',
    component: withFetch(JobSpacePage, { size: 'xxl' })(fetchJobSpacePage)
  },
  {
    name: 'JobPage',
    path: '/page-metier/:slug/pages',
    component: withFetch(JobPage, { size: 'xxl' })(fetchJobPage)
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    path: '/annuaire-des-collaborateurs',
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: EVENT_ROUTE_NAMES.calendar,
    meta: { disabled: true }
  },
  {
    name: EVENT_ROUTE_NAMES.page,
    meta: { disabled: true }
  },
  {
    name: 'SocialFeedPage',
    path: '/reseaux-sociaux',
    component: () => import('../pages/SocialFeedPage')
  },
  {
    name: 'NewComersListingPage',
    path: '/nouveaux-arrivants',
    component: () => import('../pages/newcomers/NewComersListingPage')
  },
  {
    name: 'NewComersPage',
    path: '/nouveaux-arrivants/:slug',
    component: () => import('../pages/newcomers/NewComersPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { permissionKey: 'advanced-settings', display: true }
  }
]
