export default {
  mounted() {
    if (this.isAlive(this.$_data, ['function'])) {
      this.$_addItemAfter('title', {
        value: this.getCheckedData(this.$_data, ['function']),
        class: 'function'
      })
    }
  },
  methods: {
    scaffoldCategories(fields) {
      const categoryMap = ({ title }) => ({
        class: 'category item',
        value: title
      })

      return [
        ...this.getCheckedData(fields, ['services', 'data'], []).map(
          categoryMap
        ),
        ...this.getCheckedData(fields, ['news_categories', 'data'], []).map(
          categoryMap
        )
      ]
    }
  }
}
