import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'

export default {
  'inside-commons': {
    banner: {
      imageKey: 'image'
    }
  },
  'inside-ged': {
    useV2: true,
    rootRoute: {
      fr: 'ressources'
    },
    e2e: {
      path: 'ressources',
      useLinks: false
    }
  },
  'inside-layouts': {
    darkModeMenuEnabledFor: ['HomePage'],
    templates: {
      fullContent: {
        newComer: {
          mainComponent: () => import('@inside-news/components/lib/Full')
        }
      }
    }
  },
  'inside-news': {
    showBookmarks: false,
    rootRoute: {
      fr: 'actus'
    },
    e2e: {
      path: {
        fr: 'actus'
      }
    }
  },
  'inside-teams': {
    rootRoute: {
      fr: 'forum'
    }
  },
  'inside-users': {
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-tools': {
    rootRoute: {
      fr: 'applications'
    }
  },
  'inside-events': {
    rootRoute: {
      fr: 'agenda'
    }
  },
  'inside-jobs': {
    mainContentType: 'job_offers',
    modalName: 'jobs',
    modalOptions: {
      size: 'm'
    },
    categoriesFields: [
      {
        services: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        locations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        contracts: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ],
    fields: [
      'uuid',
      'title',
      'admin',
      'content_type',
      'content',
      { locations: ['uuid', 'title'] },
      { contracts: ['title', 'uuid'] },
      { services: ['title', 'uuid'] }
    ],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'contracts',
        class: 'contracts',
        tag: markRaw(IconText),
        data: { icon: 'tools' },
        value: data?.contracts?.title
      })

      addItemAfter('contracts', {
        id: 'services',
        class: 'services ml-m',
        tag: markRaw(IconText),
        data: { icon: 'holidays' },
        value: data?.services?.title
      })
    }
  }
}
