import { http } from '@inside-library/helpers/Http'

const basicFields = [
  'uuid',
  'title',
  'slug',
  'content_type',
  'admin',
  'created_at',
  'updated_at'
]

const fetchJobSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/job_spaces', {
      fields: [
        ...basicFields,
        'image',
        'description',
        {
          key_contacts: [
            'uuid',
            'lastname',
            'firstname',
            'image',
            'function',
            'phone'
          ]
        },
        'newcomers',
        {
          documents: {
            fields: [...basicFields, 'link', 'file', 'has_section'],
            filters: {
              'status:eq': 1,
              limit: 3,
              sort: 'published_at:desc'
            }
          }
        },
        {
          applications: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        'video',
        'html',
        {
          news_categories: ['uuid', 'title']
        },
        {
          job_pages_categories: {
            fields: ['count'],
            filters: { reverse: true }
          }
        },
        'free_text',
        'iss_mobility'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    const { data: news } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'slug',
        'image',
        'chapo',
        'content_type',
        'published_at',
        { news_categories: ['uuid', 'title'] }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 4,
        news_categories: {
          'status:eq': 1,
          'uuid:in': data[0].news_categories.data.map(({ uuid }) => uuid),
          'published_at:lte': 'now()'
        }
      }
    })

    const showNewcomers = data[0].newcomers || false

    const newcomersData = showNewcomers
      ? await http.get('content/new_comer', {
          fields: [...basicFields, 'image', { services: ['title'] }],
          filters: { sort: 'created_at:desc', status: 1, limit: 3 }
        })
      : undefined

    const showJobs = data[0].iss_mobility || false

    const jobsData = showJobs
      ? await http.get('content/job_offers', {
          fields: [
            ...basicFields,
            'image',
            { contracts: ['title'] },
            { services: ['title'] },
            'admin',
            { locations: ['title'] },
            'published_at'
          ],
          filters: { sort: 'created_at:desc', status: 1, limit: 3 }
        })
      : undefined

    const returnData = {
      ...data[0],
      showNewcomers,
      newcomersData,
      showJobs,
      jobsData,
      news
    }

    return returnData
  } catch (err) {
    throw new Error(err)
  }
}

const fetchJobPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/job_spaces', {
      fields: ['uuid', 'title', 'image', 'description'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchJobSpacePage, fetchJobPage }
