import { http } from '@inside-library/helpers/Http'

export default {
  infos_flash: {
    add: () => '/',
    delete: () => '/'
  },
  contracts: {
    add: () => ({
      name: 'JobsListingPage'
    })
  },
  jobSpaces: {
    add: ({ data }) => ({
      name: 'JobSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  jobPagesCategories: {
    fields: [{ job_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'JobSpacePage',
      params: { slug: data.job_spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'JobSpacePage',
      params: { slug: data.job_spaces.slug[0] }
    })
  },
  jobPages: {
    fields: ['uuid', { job_pages_categories: [{ job_spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'JobPage',
      params: { slug: data.job_pages_categories.job_spaces.slug[0] },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'JobSpacePage',
      params: { slug: data.job_pages_categories.job_spaces.slug[0] }
    }),
    globalSearch: async ({ data, vm }) => {
      try {
        const uuidJobPages = data.uuid

        data = await http.get('content/job_pages', {
          fields: [
            {
              job_pages_categories: {
                fields: ['uuid', 'title'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidJobPages }
        })

        const uuidJobPagesCategories = data.data[0].job_pages_categories.uuid

        data = await http.get('content/job_pages_categories', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidJobPagesCategories }
        })

        vm.$router.push({
          name: 'JobPage',
          params: { slug: data.data[0].job_spaces.slug[0] },
          query: { page: uuidJobPages }
        })
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  newComer: {
    add: ({ data }) => {
      return {
        name: 'NewComersPage',
        params: {
          slug: data.slug[0]
        }
      }
    },
    delete: () => ({
      name: 'NewComersListingPage'
    })
  }
}
