import { http } from '@inside-library/helpers/Http'

const fetchServiceDesk = async () => {
  try {
    const { data } = await http.get('content/service_desk', {
      fields: [
        'uuid',
        'admin',
        'title',
        {
          bloc: {
            filters: {
              'status:eq': 1,
              sort: 'weight:asc',
              limit: 3
            },
            fields: [
              'title',
              'uuid',
              'admin',
              'bloc_content',
              'image',
              'link',
              'weight'
            ]
          }
        }
      ],
      filters: {
        'status:eq': 1,
        sort: 'created_at:desc',
        limit: 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchFlashInfos = async () => {
  try {
    const { data } = await http.get('content/infos_flash', {
      fields: ['uuid', 'content_type', 'admin', 'body'],
      filters: {
        langcode: 'fr',
        status: 1,
        sort: 'published_at:desc',
        limit: 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchServiceDesk, fetchFlashInfos }
