export default {
  // GED
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  // Groups
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  },
  // HR space
  job_offers: {
    modalFields: [
      'title',
      'published_at',
      'content',
      'uuid',
      'content_type',
      { contracts: ['title'] },
      { locations: ['title'] },
      { services: ['title'] }
    ]
  },
  // users
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'mobile',
      'image',
      'function',
      'twitter',
      'linkedin',
      { entities: ['title'] },
      { manager: ['uuid', 'image', 'firstname', 'lastname', 'function'] }
    ]
  },
  popin: {
    modalFields: ['uuid', 'title', 'content']
  }
}
