<?php

namespace Inside\ISSF\Providers;

use Inside\ISSF\Console\ImportSocialFeed;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * ISSF Service provider.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $commands = [
        ImportSocialFeed::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
