<?php

namespace Inside\ISSF\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Popin;
use Inside\Reaction\Facades\Reactions;
use Inside\Reaction\Models\Reaction;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    public function popin(Request $request): array
    {
        $now = Date::now()->toDateString();
        $popin = Popin::query()
            ->where('status', 1)
            ->whereNotNull('date')
            ->whereNotNull('end_date')
            ->whereDate('date', '<=', $now)
            ->whereDate('end_date', '>=', $now)
            ->orderBy('published_at', 'DESC')
            ->first();

        if (empty($popin)) {
            return [
                'popin' => false,
            ];
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = Reaction::where('type', 'popin')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $popin->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()).' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return [
            'popin' => ! (bool) $count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first(),
        ];
    }

    /**
     * @param Request $request
     * @return mixed
     */
    public function reaction(Request $request)
    {
        /** @var User $user */
        $user = Auth::user();
        $user = $user->uuid;
        $uuid = $request->input('uuid');

        $data = Popin::findOrFail($uuid);

        $reactions = Reaction::where('type', 'popin')
            ->where('user_uuid', $user)
            ->delete();

        return Reactions::create([
            'user_uuid' => $user,
            'reactionable_uuid' => $uuid,
            'reactionable_type' => Popin::class,
            'type' => 'popin',
            'langcode' => $data->langcode,
        ]);
    }
}
