<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddDocumentsFieldToJobSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'job_spaces', 'folders');

        $bridge->contentTypeCreateOrUpdateField('job_spaces', 'documents', [
            'name' => 'documents',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Remontée de documents',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 10,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['documents'],
                'cardinality' => -1,
            ],
        ]);
    }
}
