<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class FixDirectoryFilters extends Migration
{
    use HasConsole;

    /**
     * @var string[]
     */
    protected $fields = [
        'entities',
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach ($this->fields as $field) {
            $this->writeln(sprintf('Changing search options for %s field', $field));

            $bridge->updateFieldOptions('users', $field, [
                'searchable_filter' => true,
            ]);
        }

        $this->writeln('Rebuilding models and user index');
        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild', ['--type' => 'users']);
    }

    public function down(): void
    {
    }
}
