<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'socials',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Sociaux',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link_title',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Titre du lien',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'display_order',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
