<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

if (! function_exists('get_entity')) {
    function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim(ucwords(strtolower($record[$column])));

        if (empty($name)) {
            return null;
        }

        $query = call_user_func('Inside\\Content\\Models\\Contents\\'.Str::studly($bundle).'::query');

        $entity = $query->where('title', $name)->first();

        if ($entity) {
            return [$entity->uuid];
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

return [
    'files' => [
        'issf' => [
            'path' => env('CSV_CUSTOM_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => ';',
            'fields' => [
                'name' => function ($record, BridgeContent $bridge) {
                    return trim($record['email_iss']);
                },
                'mail' => function ($record, BridgeContent $bridge) {
                    return trim($record['email_iss']);
                },
                'firstname' => function ($record, BridgeContent $bridge) {
                    return ucwords($record['prenom']);
                },
                'lastname' => function ($record, BridgeContent $bridge) {
                    return ucwords($record['nom']);
                },
                'function' => function ($record, BridgeContent $bridge) {
                    return ucwords($record['fonction_poste']);
                },
                'phone' => function ($record, BridgeContent $bridge) {
                    return trim($record['telephone_fixe']);
                },
                'mobile' => function ($record, BridgeContent $bridge) {
                    return trim($record['telephone_mobile']);
                },
                'manager' => function ($record, BridgeContent $bridge) {
                    $user = Inside\Content\Models\Contents\Users::query()->where('email', $record['email_n+1'])->first();
                    if ($user) {
                        return $user->uuid;
                    }

                    return null;
                },
                'entities' => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'entities', 'orga_rh_1');
                },
                'status' => function ($record, BridgeContent $bridge) {
                    return true;
                },
                'langcode' => function ($record, BridgeContent $bridge) {
                    return 'fr';
                },
            ],
        ],
    ],
];
