<?php

namespace Inside\ISSF\Console;

use Illuminate\Console\Command;

/**
 * Import social feeds into inside_socials.
 */
abstract class BaseImport extends Command
{
    /**
     * Holds stats info
     *
     * @var array
     */
    protected $stats = [];

    /**
     * Add info into stats
     * @param string $model
     * @param string $action
     * @param int $count
     */
    protected function addStat(string $model, string $action, int $count = 1): void
    {
        // Model
        if (! isset($this->stats[$model])) {
            $this->stats[$model] = [];
        }

        // Count
        if (! isset($this->stats[$model][$action])) {
            $this->stats[$model][$action] = $count;
        } else {
            $this->stats[$model][$action] += $count;
        }
    }

    /**
     * Format stats to text
     * @return string
     */
    protected function formatStats(): string
    {
        $text = [];
        foreach ($this->stats as $model => $actions) {
            foreach ($actions as $action => $value) {
                $text[] = "$value $model $action";
            }
        }

        return implode(', ', $text);
    }
}
