<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/issf-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/issf-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'sorts' => ['published_at:desc'],
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#0084FF',
            'link' => [
                'sectionLinkUrl'  => 'actus',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'agenda',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'ressources',
                'sectionTextColor' => '#2C3E50'
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#081137',
        'links' => [
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/iss-france',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/iss.france/?hl=fr',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/@issfrance3141',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/issfrance',
            ],
            'facebook' => [
                'url' => 'https://www.facebook.com/ISSWorldFrance/',
            ],
            'yammer' => [
                'url' => 'https://web.yammer.com/main/groups/eyJfdHlwZSI6Ikdyb3VwIiwiaWQiOiI3NzI4OTA2In0',
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
