<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdatePopinAddDateAndEndDate extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $weight = 1;
        $bridge->contentTypeCreateOrUpdateField('popin', 'date', [
            'name' => 'date',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Date de début',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('popin', 'end_date', [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => true,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Date de fin',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }
}
