<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSocialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_socials', function (Blueprint $t) {
            $t->increments('id');
            $t->dateTime('date');
            $t->string('account_name', 255);
            $t->string('account_type', 20);
            $t->string('import_id', 255);
            $t->longText('content');
            $t->index('account_name');
            $t->index('account_type');
            $t->index('import_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_socials');
    }
}
