<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'name' => 'social_feed_account',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'listing_type' => 'hidden',
        'categorizable' => false,
        'title' => [
            'fr' => 'Compte réseau social',
        ],
    ],
    'fields' => [
        [
            'name' => 'avatar_url',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'editable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Avatar URL',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'name',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'editable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight++,
            'title' => [
                'fr' => 'Display Name',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'feed_type',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'editable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Type',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
