<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'name' => 'job_offers',
        'title' => [
            'fr' => 'Offre d\'emploi',
        ],
    ],
    'fields' => [
        [
            'name' => 'contracts',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Type de contrat',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['contracts'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'services',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Service',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['services'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'locations',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'editable' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraph',
                    'title_plural' => 'Paragraphs',
                    'edit_mode' => 'closed',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '_none',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => ['text', 'image', 'text_with_image', 'slider', 'file', 'accordion', 'call_to_action', 'video', 'html', 'map'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'date',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Date de début',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'email',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Email destinataire',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
