import SpacePage from '../pages/space/SpacePage'
import SpaceDirectoryPage from '../pages/space/SpaceDirectoryPage'
import { fetchSpaceDirectory, fetchSpacePage } from '../components/spaces/fetch'

import DomainsPage from '../pages/domains/DomainsPage'
import { fetchBusinessArea } from '../components/domains/domains'

import WallPage from '../pages/walls/WallPage'
import { fetchWall } from '../components/walls/fetch'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

const fields = [
  'uuid',
  'title',
  'slug',
  'content_type',
  'admin',
  'published_at',
  'updated_at',
  'content',
  'image',
  'chapo',
  { reactions: ['count', { users: ['uuid'] }] },
  { comments: ['count'] },
  {
    news_categories: {
      fields: ['uuid', 'title', 'slug', 'content_type', 'color'],
      filters: { 'status:eq': 1 }
    }
  }
]

const relatedFields = [
  'uuid',
  'title',
  'slug',
  'content_type',
  'admin',
  'published_at',
  'updated_at',
  'image',
  'chapo',
  { reactions: ['count', { users: ['uuid'] }] },
  { comments: ['count'] }
]

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: {
      disabled: false
    }
  },
  {
    name: 'NewsPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'EventsCalendarPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'EventPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false }
  },
  {
    name: 'WallPage',
    component: withFetch(WallPage, { size: 'xl', watch: true })(fetchWall),
    meta: { disabled: false }
  },
  {
    name: 'ContractsListingPage',
    path: '/contrats',
    component: () => import('@inside-news/components/pages/ListingPage'),
    meta: { customSlug: 'contracts' },
    props: {
      contentType: 'contracts',
      filtersInput: 'selectbox',
      categoriesFields: [
        {
          business_areas: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ],
      extraFields: [
        {
          business_areas: ['uuid', 'title', 'color']
        }
      ],
      componentAttributes: () => ({
        categoriesConfig: {
          business_areas: {
            data: (data, contentType, { getData }) => getData(data, contentType)
          }
        }
      }),
      contentRoot: {
        contracts: item => ({
          name: 'ContractsPage',
          params: { slug: item.slug[0] }
        })
      }
    }
  },
  {
    name: 'ContractsPage',
    path: '/contrats/:slug',
    component: () => import('@inside-news/components/pages/NewsPage'),
    props: {
      contentType: 'contracts',
      fields,
      configModule: 'inside-customs',
      relatedOptions: {
        fields: relatedFields,
        componentAttributes: item => ({
          to: {
            name: 'ContractsPage',
            params: {
              slug: item.slug[0]
            }
          }
        })
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage.vue'),
    meta: { disabled: false }
  },
  {
    path: '/les-idees',
    name: 'IdeasPage',
    component: () => import('../pages/ideas/IdeasPage')
  },
  {
    path: '/mes-idees',
    name: 'MyIdeasPage',
    component: () => import('../pages/ideas/MyIdeasPage')
  },
  {
    path: '/proposer-une-nouvelle-idee',
    name: 'FormIdeasPage',
    component: () => import('../pages/ideas/FormIdeasPage')
  },
  {
    name: 'LaunchesListingPage',
    path: '/lancements-et-livraisons',
    component: () => import('@inside-news/components/pages/ListingPage'),
    meta: { customSlug: 'launches' },
    props: {
      contentType: 'launches',
      filtersInput: 'selectbox',
      categoriesFields: [
        {
          business_areas: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ],
      extraFields: [
        {
          business_areas: ['uuid', 'title', 'color']
        }
      ],
      componentAttributes: () => ({
        categoriesConfig: {
          business_areas: {
            data: (data, contentType, { getData }) => getData(data, contentType)
          }
        }
      }),
      contentRoot: {
        launches: item => ({
          name: 'LaunchesPage',
          params: { slug: item.slug[0] }
        })
      }
    }
  },
  {
    name: 'LaunchesPage',
    path: '/lancements-et-livraisons/:slug',
    component: () => import('@inside-news/components/pages/NewsPage'),
    props: {
      contentType: 'launches',
      configModule: 'inside-customs',
      fields,
      relatedOptions: {
        fields: relatedFields,
        componentAttributes: item => ({
          to: {
            name: 'LaunchesPage',
            params: {
              slug: item.slug[0]
            }
          }
        })
      }
    }
  },
  {
    name: 'ProfileUser',
    component: () => import('../pages/profile/ProfileUserPage')
  },
  {
    path: '/espaces-thematiques',
    name: 'SpacesListingPage',
    component: () => import('../pages/space/SpacesListingPage')
  },
  {
    path: '/espace/:slug',
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    path: '/espace/:slug/annuaire',
    name: 'SpaceDirectoryPage',
    component: withFetch(SpaceDirectoryPage, { size: 'xxl', watch: true })(
      fetchSpaceDirectory
    )
  },
  {
    path: '/espace/:slug/documents',
    name: 'SpaceGEDPage',
    component: () => import('../pages/space/SpaceGEDPage')
  },
  {
    name: 'ToolsPage',
    component: () => import('../pages/tools/ToolsPage'),
    meta: { disabled: false },
    path: '/outils'
  },
  {
    name: 'JobsListingPage',
    path: '/offres-d-emploi',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false
    }
  },
  {
    path: '/domaines/:slug',
    name: 'DomainsPage',
    component: withFetch(DomainsPage, { size: 'xxl', watch: true })(
      fetchBusinessArea
    )
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
