import { http } from '@inside-library/helpers/Http'

const spaceDocLink = async function (spaceFolderUuid) {
  try {
    const res = await http.get('content/space_folders', {
      fields: [{ spaces: ['slug'] }],
      filters: { 'uuid:eq': spaceFolderUuid }
    })

    return {
      name: 'SpaceGEDPage',
      params: {
        slug: res.data[0].spaces.data[0].slug[0]
      },
      query: {
        folder: spaceFolderUuid
      }
    }
  } catch (err) {
    return { name: 'SpacesListingPage' }
  }
}

export default {
  classifiedAds: {
    add: () => '/communaute-sodern',
    delete: () => '/communaute-sodern'
  },
  ideas: {
    add: () => ({ name: 'MyIdeasPage' }),
    delete: () => ({ name: 'MyIdeasPage' })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'SpacesListingPage' })
  },
  jobOffers: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({ name: 'JobsListingPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spaceFolders: {
    add: async ({ data, fields }) => {
      try {
        const res = await http.get('content/spaces', {
          fields: ['slug'],
          filters: {
            'uuid:eq': fields ? fields.spaces[0] : data.spaces[0].uuid
          }
        })

        return {
          name: 'SpaceGEDPage',
          params: {
            slug: res.data[0].slug[0]
          },
          query: {
            folder: data.uuid
          }
        }
      } catch (err) {
        return { name: 'SpacesListingPage' }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spaceDocuments: {
    add: async ({ data, fields }) => {
      let spaceFolder

      if (fields) {
        spaceFolder = fields.space_folders
      } else {
        spaceFolder = data.space_folders.uuid
      }

      return await spaceDocLink(spaceFolder)
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spaceDmsLink: {
    extends: 'spaceDocuments'
  },
  news: {
    disabled: false
  },
  newsCategories: {
    disabled: false
  },
  contracts: {
    add: ({ data }) => {
      return {
        name: 'ContractsPage',
        params: {
          slug: data.slug[0]
        }
      }
    },
    delete: () => ({
      name: 'ContractsListingPage'
    })
  },
  launches: {
    add: ({ data }) => ({
      name: 'LaunchesPage',
      params: {
        slug: data.slug[0]
      }
    }),
    delete: () => ({
      name: 'NewsListingPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  veilleMarketing: {
    add: () => ({
      name: 'AdminMailingsListPage'
    }),
    delete: () => ({
      name: 'AdminMailingsListPage'
    })
  }
}
