import insideConfig from './inside.config.js'
import i18n from './i18n'
import redirections from './redirections'
import routes from './router'

import HeaderLayouts from '../inside-overrides/inside-layouts/HeaderLayouts'
import HorizontalLayouts from '../inside-overrides/inside-layouts/HorizontalLayouts'
import FooterCommon from '../inside-overrides/inside-library/common/FooterCommon'
import JobBoardModal from '../inside-overrides/inside-library/modals/JobBoardModal'
import WelcomeModal from '../inside-overrides/inside-library/modals/WelcomeModal'
import HeaderCtaParagraph from '../inside-overrides/inside-library/paragraphs/HeaderCtaParagraph'
import HeaderFileParagraph from '../inside-overrides/inside-library/paragraphs/HeaderFileParagraph'
import LinkListParagraph from '../inside-overrides/inside-library/paragraphs/LinkListParagraph'
import ResponsibleMessageParagraph from '../inside-overrides/inside-library/paragraphs/ResponsibleMessageParagraph'
import GalleryUi from '../inside-overrides/inside-library/ui/GalleryUi'
import ToolsModal from '../inside-overrides/inside-tools/ToolsModal'
import UserModal from '../inside-overrides/inside-users/modals/UserModal'

export default {
  name: 'inside-customs',
  init: app => {
    app.component('header-layouts', HeaderLayouts)
    app.component('horizontal-layouts', HorizontalLayouts)
    app.component('footer-common', FooterCommon)
    app.component('job-board-modal', JobBoardModal)
    app.component('welcome-modal', WelcomeModal)
    app.component('header-cta-paragraph', HeaderCtaParagraph)
    app.component('header-file-paragraph', HeaderFileParagraph)
    app.component('link-list-paragraph', LinkListParagraph)
    app.component('responsible-message-paragraph', ResponsibleMessageParagraph)
    app.component('gallery-ui', GalleryUi)
    app.component('tools-modal', ToolsModal)
    app.component('user-modal', UserModal)
  },
  insideConfig,
  i18n,
  redirections,
  routes
}
