import { http } from '@inside-library/helpers/Http'

export const fetchWall = async ({ $route }) => {
  try {
    const { data } = await http.get('content/walls', {
      fields: [
        'uuid',
        'title',
        'image',
        'description',
        'content_type',
        'admin',
        { comments: ['count'] }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
