import { http } from '@inside-library/helpers/Http'

const fetchForm = async ({ $route }) => {
  const currentRoute = $route.path.replace(/\//, '')

  try {
    const { data } = await http.get('content/custom', {
      fields: [
        'uuid',
        'title',
        'body',
        'link',
        'link_title',
        'slug',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': currentRoute
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
export { fetchForm }
