import { http } from '@inside-library/helpers/Http'

const fetchInformationBanner = async () => {
  try {
    const { data } = await http.get('content/information_banner', {
      fields: [
        'uuid',
        'title',
        'admin',
        'link',
        'link_title',
        'informations',
        'content_type'
      ],
      filters: {
        limit: 1,
        sort: 'published_at:desc',
        'status:eq': 1,
        'published_at:lte': 'now()',
        'end_date:gte': 'now()'
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchCardLink = async () => {
  try {
    const { data } = await http.get('content/image_block', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'published_at',
        'content_type',
        'open_in_new_tab'
      ],
      filters: { 'status:eq': 1, sort: 'weight:asc', limit: 2 }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchInformationBanner, fetchCardLink }
