const state = {
  answers: {},
  currentQuestion: 0,
  isGameOver: false,
  screen: 'home',
  unlocked: 0
}

/**
 * Getters
 */
const getters = {
  getAnswers: state => state.answers,
  getCurrentQuestion: state => state.currentQuestion,
  getIsGameOver: state => state.isGameOver,
  getScreen: state => state.screen,
  getUnlocked: state => state.unlocked
}

/**
 * Actions
 */
const actions = {}

/**
 * Mutations
 */
const mutations = {
  setAnswers(state, payload) {
    state.answers = payload
  },
  setCurrentQuestion(state, payload) {
    state.currentQuestion = payload
  },
  setIsGameOver(state, payload) {
    state.isGameOver = payload
  },
  setScreen(state, payload) {
    state.screen = payload
  },
  setUnlocked(state, payload) {
    state.unlocked = payload
  }
}

export default {
  state,
  getters,
  actions,
  mutations
}
