export default {
  globals: {
    notificationRedirectionsContentTypes: ['spaces'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'News',
        params: {
          slug: data.slug[0]
        }
      }),
      spaces: async ({ data }) => ({
        name: 'SpacePage',
        params: {
          slug: data.slug[0]
        }
      })
    },
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-broadcasts': {
    enabled: false
  },
  'inside-comments': {
    rootRoute: {
      fr: 'murs-de-discussion'
    }
  },
  'inside-commons': {
    banner: {
      introductionKey: 'body',
      html: true
    }
  },
  'inside-customs': {
    templates: {
      fullContent: {
        contracts: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        },
        launches: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-events': {
    calendarImportEnabled: true
  },
  'inside-ged': {
    rootRoute: {
      fr: 'mediatheque'
    }
  },
  'inside-users': {
    allowAvatarDeletion: false,
    extraComponent: {
      'infos-profile': 'components/profile/HardwareListingCustoms'
    },
    login: {
      useGradient: false,
      useImage: false,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 8,
      content: 'tools_shortcuts'
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
