import { http } from '@inside-library/helpers/Http'

const fetchNews = async ({ $route }) => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        { reactions: ['count', { users: ['uuid'] }] },
        { comments: ['count'] },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 4,
        news_categories: {
          spaces: {
            'slug:eq': $route.params.slug
          }
        }
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchJobs = async () => {
  try {
    const { data } = await http.get('content/job_offers', {
      fields: ['uuid', 'title', 'image', 'published_at', 'content_type'],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchFolders = async ({ $route }) => {
  try {
    const { data } = await http.get('content/space_folders', {
      fields: [
        'image',
        'admin',
        'title',
        'content_type',
        'slug',
        'uuid',
        'uuid'
      ],
      filters: {
        'pid:eq': null,
        'status:eq': 1,
        sort: 'weight:asc',
        spaces: {
          'slug:eq': $route.params.slug
        }
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      filters: {
        'slug:eq': $route.params.slug
      },
      fields: [
        'title',
        'uuid',
        'has_section',
        'content',
        'content_type',
        'body',
        'email',
        'header_image',
        'space_link1',
        'space_link1_label',
        'space_link2',
        'space_link2_label',
        'space_link3',
        'space_link3_label',
        'space_link4',
        'space_link4_label',
        'admin',
        'slug',
        {
          users: {
            filters: { limit: 3, sort: 'lastname:asc', 'status:eq': 1 },
            fields: ['firstname', 'lastname', 'uuid', 'image']
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSpaceDirectory = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      filters: {
        'slug:eq': $route.params.slug
      },
      fields: [
        'title',
        'slug',
        {
          users: {
            filters: { sort: 'lastname:asc' },
            fields: [
              'firstname',
              'lastname',
              'uuid',
              'image',
              'function',
              'phone',
              'content_type',
              { services: ['title'] }
            ]
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export {
  fetchNews,
  fetchJobs,
  fetchFolders,
  fetchSpacePage,
  fetchSpaceDirectory
}
