import { http } from '@inside-library/helpers/Http'

const fetchBusinessArea = async ({ $route }) => {
  try {
    const { data } = await http.get('content/business_areas', {
      fields: ['uuid', 'title', 'slug', 'content_type'],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
export { fetchBusinessArea }
