export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] }
    ]
  },
  ideas: {
    extendedUrl: ['uuid']
  },
  job_offers: {
    extendedUrl: ['uuid'],
    modalFields: [
      'title',
      'content',
      { authors: ['uuid', 'lastname', 'firstname'] },
      'uuid',
      'slug',
      'content_type',
      'published_at',
      'email',
      'status',
      'langcode',
      'desired_start_date',
      'job_description',
      { working_area: ['uuid', 'title'] },
      'remuneration',
      'experience_level',
      'qualifications',
      { sodern_department: ['uuid', 'title'] },
      { work_time_type: ['uuid', 'title'] },
      { employment_contract_type: ['uuid', 'title'] },
      'video_url'
    ]
  },
  modal: {
    modalFields: ['class', 'content']
  },
  space_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'image',
      'firstname',
      'lastname',
      'function',
      'cost_center',
      'samaccountname',
      'trigram',
      { services: ['uuid', 'slug', 'title'] },
      'office',
      'other_location',
      'email',
      'phone',
      'mobile_phone',
      'uuid',
      {
        company: ['uuid', 'title']
      },
      {
        operational_manager: [
          'firstname',
          'lastname',
          'uuid',
          'function',
          'image'
        ]
      },
      {
        prestation_manager: [
          'firstname',
          'lastname',
          'uuid',
          'function',
          'image'
        ]
      },
      'project_1',
      'project_2',
      'project_3',
      'project_4',
      'project_5',
      'finished_project_1',
      'finished_project_2',
      'finished_project_3',
      'finished_project_4',
      'finished_project_5',
      { complementary_roles: ['title', 'uuid'] },
      'other_complementary_roles',
      { ep_passions: ['title', 'uuid', 'passion_icon'] },
      'ep_other_passions',
      'associative_role',
      'programs',
      'who_to_contact',
      'is_external',
      'linkedin'
    ]
  }
}
