<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\ISOD\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        /**
         * Sodern Game
         */
        $router->get('game/informations', 'GameController@informations');
        $router->put('game/informations', 'GameController@update');
        $router->get('game/informations/export', 'GameController@export');
        $router->get('game/export/{fileName}', 'GameController@serveExport');

        /**
         * Sodern equipments
         */
        $router->get('equipment', 'EquipmentController@list');
    }
);
