<?php

namespace Inside\ISOD;

use Illuminate\Support\Facades\Log;
use Inside\Host\Bridge\BridgeContent;
use Symfony\Component\Workflow\Marking;
use Symfony\Component\Workflow\MarkingStore\MarkingStoreInterface;

class SingleStateMarkingStore implements MarkingStoreInterface
{
    public function __construct()
    {
    }

    public function getMarking(object $subject): Marking
    {
        $placeName = $subject->getOriginal('idea_status');

        if (!$placeName) {
            return new Marking();
        }

        return new Marking([(string)$placeName => 1]);
    }

    public function setMarking(object $subject, Marking $marking, array $context = []): void
    {
        $subject->idea_status = key($marking->getPlaces());
        Log::debug('[SingleStateMarkingStore::setMarking] new marking {' . $subject . '}');
        $bridge = new BridgeContent();
        $bridge->contentUpdate(
            'ideas',
            [
                'uuid'        => $subject->uuid,
                'bundle'      => 'ideas',
                'type'        => 'node',
                'author'      => $subject->authors->uuid,
                'idea_status' => $subject->idea_status,
            ]
        );
    }
}
