<?php

namespace Inside\ISOD\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentProcessedEvent;
use Inside\Content\Events\ContentPublishedEvent;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\ISOD\Console\Commands\DumpIdeasBoxWorkflowCommand;
use Inside\ISOD\Console\Commands\InsideImport;
use Inside\ISOD\Console\Commands\UpdatePictures;
use Inside\ISOD\Events\CollaboratorSetEvent;
use Inside\ISOD\Events\IdeaCreatedEvent;
use Inside\ISOD\Http\Middleware\AddMessagesToWelcomeModal;
use Inside\ISOD\Http\Middleware\ManageExternalFieldsOnProfileForm;
use Inside\ISOD\Http\Middleware\ManageMessageFieldsOnProfileForm;
use Inside\ISOD\Http\Middleware\PrepareIdeasCreation;
use Inside\ISOD\Http\Middleware\PrepareIdeasList;
use Inside\ISOD\Http\Middleware\PrepareIdeasUpdate;
use Inside\ISOD\Http\Middleware\PrepareIdeasView;
use Inside\ISOD\Http\Middleware\EquipmentFormMiddleware;
use Inside\ISOD\Listeners\AddDefaultValidatorOnIdeaCreation;
use Inside\ISOD\Listeners\ComplexeIdeaRefused;
use Inside\ISOD\Listeners\ContentPublishedListener;
use Inside\ISOD\Listeners\EventAlert;
use Inside\ISOD\Listeners\IdeaValidated;
use Inside\ISOD\Listeners\NotifyOnCollaboratorSet;
use Inside\ISOD\Listeners\NotifyOnIdeaCreation;
use Inside\ISOD\Listeners\RegisterSodernUsersToMarketingNewsletterListener;
use Inside\ISOD\Listeners\WorkDoneAndNeedValidation;
use Inside\ISOD\Listeners\WorkDoneAndValidated;
use Inside\ISOD\Listeners\WorkflowReviewedListener;
use Inside\ISOD\Services\IdeasBox;
use Inside\Permission\Events\RoleAttachedEvent;
use Inside\Permission\Events\RoleDetachedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\Workflow\Events\ProposalReviewedEvent;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            EventAlert::class,
        ],
        ContentProcessedEvent::class => [
            RegisterSodernUsersToMarketingNewsletterListener::class,
        ],
        ContentPublishedEvent::class => [
            ContentPublishedListener::class,
        ],
        ProposalReviewedEvent::class => [
            WorkflowReviewedListener::class,
        ],
        IdeaCreatedEvent::class => [
            NotifyOnIdeaCreation::class,
            AddDefaultValidatorOnIdeaCreation::class,
        ],
        ContentUpdatingEvent::class => [
            RegisterSodernUsersToMarketingNewsletterListener::class,
        ],
        RoleAttachedEvent::class => [
            RegisterSodernUsersToMarketingNewsletterListener::class,
        ],
        RoleDetachedEvent::class => [
            RegisterSodernUsersToMarketingNewsletterListener::class,
        ],
        CollaboratorSetEvent::class => [
            NotifyOnCollaboratorSet::class,
        ],
        'workflow.ideasbox.entered.work_in_progress' => [
            IdeaValidated::class,
        ],
        'workflow.ideasbox.entered.simple_work_in_progress' => [
            IdeaValidated::class,
        ],
        'workflow.ideasbox.entered.idea_refused' => [
            ComplexeIdeaRefused::class,
        ],
        'workflow.ideasbox.entered.work_in_review' => [
            WorkDoneAndNeedValidation::class,
        ],
        'workflow.ideasbox.entered.work_validated' => [
            WorkDoneAndValidated::class,
        ],
    ];

    protected array $commands = [
        InsideImport::class,
        DumpIdeasBoxWorkflowCommand::class,
        UpdatePictures::class,
    ];

    public array $bindings = [
        'inside.isod.ideas_box' => IdeasBox::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/import.php', 'import');
            $this->mergeConfigFrom(__DIR__.'/../../config/archive.php', 'archive');
            $this->mergeConfigTo(__DIR__.'/../../config/newsletters.php', 'newsletters');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/stopwords.php', 'stopwords');
            $this->mergeConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeConfigFrom(__DIR__.'/../../config/news.php', 'news');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([
            AddMessagesToWelcomeModal::class,
            EquipmentFormMiddleware::class,
            ManageExternalFieldsOnProfileForm::class,
            ManageMessageFieldsOnProfileForm::class,
            PrepareIdeasList::class,
            PrepareIdeasView::class,
            PrepareIdeasCreation::class,
            PrepareIdeasUpdate::class,
        ]);

        // ExcelServiceProvider
        if (class_exists(\Maatwebsite\Excel\ExcelServiceProvider::class)) {
            $this->app->register(\Maatwebsite\Excel\ExcelServiceProvider::class);
        }
    }
}
