<?php

namespace Inside\ISOD\Listeners;

use Inside\Content\Listeners\BaseContentListener;
use Inside\Content\Models\Contents\News;
use Inside\Host\Bridge\BridgeContent;
use Inside\Workflow\Events\ProposalReviewedEvent;

/**
 * Content published listener
 *
 * @category Class
 * @package  Inside\Content\Listeners
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class WorkflowReviewedListener extends BaseContentListener
{
    /**
     * {@inheritDoc}
     */
    public function handle(ProposalReviewedEvent $event): void
    {
        $proposal = $event->proposal;
        $model = $event->proposable;

        if (class_to_type(get_class($model)) !== 'news') {
            return;
        }

        $model = call_user_func(get_class($model).'::find', $model->uuid);

        if (!$proposal->status || !$model->status || !$model->is_featured) {
            return;
        }

        $bridge = new BridgeContent();
        $maxFeaturedNews = config('news.max_featured_news');

        News::withoutEvents(
            function () use ($bridge, $maxFeaturedNews) {
                News::withoutGlobalScopes()
                    ->where('status', 1)
                    ->where('is_featured', 1)
                    ->orderBy('created_at', 'desc')
                    ->get()
                    ->skip($maxFeaturedNews)
                    ->each(fn (News $news) => $bridge->contentUpdate('news', [
                        'uuid' => $news->uuid,
                        'is_featured' => false,
                    ]));
            }
        );
    }
}
