<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Notification;
use Inside\Authentication\Models\User;
use Inside\ISOD\Events\IdeaCreatedEvent;
use Inside\ISOD\Notifications\ComplexeIdeaNeedValidation;
use Inside\ISOD\Notifications\IdeaCreated;
use Inside\ISOD\Notifications\SimpleIdeaCreated;

class NotifyOnIdeaCreation implements ShouldQueue
{
    public function handle(IdeaCreatedEvent $event): void
    {
        $idea    = $event->idea;
        $manager = $idea->authors->operationalManager;
        if ($manager !== null && $manager->isNotEmpty()) {
            $manager = User::find($manager->first()->uuid);
            if ($idea->idea_type == 'complexe') {
                Notification::send($manager, new ComplexeIdeaNeedValidation($idea, $event->user));
            } elseif ($idea->idea_type == 'simple') {
                Notification::send($manager, new SimpleIdeaCreated($idea, $event->user));
            }
        }
    }
}
