<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\Events;
use Inside\ISOD\Jobs\WarnUsersBeforeEvent;

class EventAlert implements ShouldQueue
{
    /**
     * @param mixed $event
     * @return void
     */
    public function handle($event): void
    {
        $event = $event->model;
        if (get_class($event) === Events::class) {
            // Remove actual warn job
            $jobs = DB::table('inside_jobs')->get();
            foreach ($jobs as $job) {
                $payload = json_decode($job->payload);

                $payloadCommand = unserialize($payload->data->command);
                if ($payloadCommand instanceof WarnUsersBeforeEvent && $payloadCommand->event == $event) {
                    DB::table('inside_jobs')->where('id', $job->id)->delete();
                }
            }
            $startDate = Carbon::createFromTimestamp($event->date, 'UTC');

            // Delay job
            if (config('queue.connections.lts', false)) {
                WarnUsersBeforeEvent::dispatch($event)->delay($startDate->subHours(2))->onConnection(
                    'lts'
                );
            } else {
                WarnUsersBeforeEvent::dispatch($event)->delay($startDate->subHours(2));
            }
        }
    }
}
