<?php

namespace Inside\ISOD\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Host\Bridge\BridgeContent;
use Inside\ISOD\Events\IdeaCreatedEvent;
use Inside\ISOD\Notifications\IdeaCreated;

/**
 * Class AddDefaultValidatorOnIdeaCreation
 *
 * @package Inside\ISOD\Listeners
 */
class AddDefaultValidatorOnIdeaCreation
{
    public function handle(IdeaCreatedEvent $event): void
    {
        $idea = $event->idea;

        $manager = $idea->authors->operationalManager;
        if ($manager && $manager->isNotEmpty()) {
            $manager = $manager->first();
            // If author has a manager, by default the manager is its validator !
            Log::debug('[AddDefaultValidatorOnIdeaCreation::handle] Assign idea_validator <' . $manager->email . '>');
            if ($manager) {
                $bridge = new BridgeContent();
                $bridge->contentUpdate(
                    'ideas',
                    [
                        'uuid'           => $idea->uuid,
                        'bundle'         => 'ideas',
                        'type'           => 'node',
                        'idea_validator' => [$manager->uuid],
                        'author'         => $idea->authors->uuid,
                    ]
                );
            }
        }
    }
}
