<?php

namespace Inside\ISOD\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Contents\Events;
use Inside\Jobs\Bus\Dispatchable;
use Inside\Notify\Events\CustomNotificationEvent;

class WarnUsersBeforeEvent implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;

    /** @var Events */
    public $event;

    public function __construct(Events $event)
    {
        $this->event = $event;
    }

    public function handle(): void
    {
        Log::debug(
            '[WarnUsersBeforeEvent] trigger event CustomNotificationEvent with event ' . $this->event->title . ':'
            . $this->event->uuid . ' ('.$this->event->author.')'
        );
        event(
            new CustomNotificationEvent(
                [
                    'model'     => 'events',
                    'uuid'      => $this->event->uuid,
                    'user_uuid' => $this->event->author,
                    'action'    => 'warn',
                ]
            )
        );
    }
}
