<?php

namespace Inside\ISOD\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Inside\ISOD\Models\Equipment;

/**
 * Newsletter middleware
 *
 * @category Class
 * @package  Inside\Newsletters\Http\Middleware\NewslettersMiddleware
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class EquipmentFormMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $path = $request->path();

        $response = $next($request);

        if (strpos($path, 'api/v1/form/') === false) {
            return $response;
        }

        $segments = explode('/', $path);
        $type = $segments[3];

        if ($type !== 'users' || count($segments) < 5) {
            return $response;
        }

        $data = json_decode_response($response);

        $label = [];

        $result = [
            'id' => 'group_isod_equipment',
            'weight' => 50,
            'type' => 'fieldset',
            'classes' => '',
            'label' => [],
            'fields' => [],
        ];

        $description = [];
        foreach (list_languages() as $language) {
            $result['label'][$language] = Lang::get('isod.equipment.fieldset', [], $language);
            $description[$language] = Lang::get('isod.equipment.fieldset.tooltip', [], $language);
        }
        $equipments = Equipment::query()->where('user_uuid', $segments[4])->with('softwares')->get();

        $softwares = [];
        $softwareValues = [];
        $formatted = [];
        $values = [];

        /** @var Equipment $equipment */
        foreach ($equipments as $equipment) {
            $formattedEquipment = [
                'uuid' => $equipment->id,
                'title' => $equipment->title,
            ];

            $values[] = $equipment->id;

            if (!empty($equipment->softwares)) {
                $formattedEquipment['children'] = [];
                foreach ($equipment->softwares as $software) {
                    $formattedEquipment['children'][] = [
                        'uuid' => $software->id,
                        'title' => $software->title,
                    ];

                    $values[] = $software->id;
                }
            }

            $formatted[] = $formattedEquipment;
        }

        $result['fields'][] = [
            'name' => 'isod_equipments',
            'description' => $description,
            'options' => [
                'cardinality' => -1,
                'categorizable' => false,
                'allowed_values' => [
                    'equipments' => [env('APP_LOCALE') => $formatted],
                ],
                'description' => $description,
                'title' => Lang::get('isod.equipment.fieldset.equipments', [], env('APP_LOCALE')),
                'widget' => 'select',
                'widget_type' => 'select',
                'default' => [],
                'target' => ['equipments'],
            ],
            'value' => $values,
            'type' => 'select',
            'weight' => 100000,
        ];

        $data['data'][] = $result;
        set_response($response, $data);

        return $response;
    }
}
