<?php

namespace Inside\ISOD\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

/**
 * Class CustomizeResponse
 *
 * @package Inside\ISOD\Http\Middleware
 */
abstract class CustomizeResponse
{
    /**
     * @var array
     */
    protected $pathes = [];

    /**
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (isset($this->pathes[$request->getMethod()])) {
            foreach ($this->pathes[$request->getMethod()] as $match) {
                $matches = [];
                if (strlen($match) > 2 && $match[0] === '#' && preg_match(
                    $match,
                    $request->path(),
                    $matches
                ) > 0) {// Assume it's a regex
                    return $this->patch($request, $next($this->patchRequest($request)), $matches);
                } elseif ($match === $request->path()) {
                    return $this->patch($request, $next($this->patchRequest($request)));
                }
            }
        }

        return $next($request);
    }

    protected function patchRequest(Request $request): Request
    {
        return $request;
    }

    /**
     * @param Request $request
     * @param mixed $response
     * @param array $data
     * @return mixed
     */
    abstract protected function patch(Request $request, $response, array $data = []);

    protected function fields(Request $request, string $key = null): ?array
    {
        if (($fields = json_decode($request->get('fields'), true)) === null) {
            return [];
        }
        $result = [];
        foreach ($fields as $field) {
            if (is_array($field)) {
                $result[array_key_first($field)] = array_first($field);
            } else {
                $result[$field] = ['*'];
            }
        }

        return is_string($key) ? ($result[$key] ?? null) : $fields;
    }

    protected function removeField(Request $request, string $fieldName): Request
    {
        $inputs = $request->all();
        if (!array_key_exists('fields', $inputs)) {
            return $request;
        }
        $fields = json_decode($inputs['fields'], true);
        foreach ($fields as $key => $field) {
            if (is_array($field)) {
                if (array_first($field) == $fieldName) {
                    unset($fields[$key]);
                }
            } else {
                if ($field == $fieldName) {
                    unset($fields[$key]);
                }
            }
        }
        $inputs['fields'] = json_encode($fields);

        $request->replace($inputs);

        return $request;
    }
}
