<?php

namespace Inside\ISOD\Game\Exports;

use Inside\ISOD\Game\Models\Informations;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

/**
 * Class InformationsExport
 *
 * @package Inside\ISOD\Game\Exports
 */
class InformationsExport implements FromQuery, WithMapping, WithHeadings, WithColumnFormatting, ShouldAutoSize
{
    use Exportable;

    public function query()
    {
        return Informations::whereNotNull('answer1')
                             ->whereNotNull('answer2')
                             ->whereNotNull('answer3')
                             ->whereNotNull('answer4')
                             ->whereNotNull('answer5')
                             ->whereNotNull('answer6')
                             ->whereNotNull('answer7')
                             ->whereNotNull('answer8');
    }

    public function map($information): array
    {
        return [
            (!empty($information->user->samaccountname) ? $information->user->samaccountname : $information->user->email),
            Date::dateTimeToExcel($information->updated_at),
            $this->formatAnswer($information->answer1),
            $this->formatAnswer($information->answer2),
            $this->formatAnswer($information->answer3),
            $this->formatAnswer($information->answer4),
            $this->formatAnswer($information->answer5),
            $this->formatAnswer($information->answer6),
            $this->formatAnswer($information->answer7),
            $this->formatAnswer($information->answer8),
        ];
    }

    public function headings(): array
    {
        return [
            '#',
            'Date',
            'Réponse 1',
            'Réponse 2',
            'Réponse 3',
            'Réponse 4',
            'Réponse 5',
            'Réponse 6',
            'Réponse 7',
            'Réponse 8',
        ];
    }

    public function columnFormats(): array
    {
        return [
            'B' => NumberFormat::FORMAT_DATE_DDMMYYYY,
        ];
    }

    protected function formatAnswer(int $answer): ?string
    {
        switch ($answer) {
            case 0:
                return 'A';
            case 1:
                return 'B';
            case 2:
                return 'C';
            case 3:
                return 'D';
        }

        return null;
    }
}
