<?php

namespace Inside\ISOD\Events;

use Symfony\Component\Workflow\Event\Event as SymfonyEvent;
use Symfony\Component\Workflow\Marking;
use Symfony\Component\Workflow\Transition;
use Symfony\Component\Workflow\WorkflowInterface;

abstract class WorkflowEvent
{
    /**
     * @var SymfonyEvent
     */
    protected $internalEvent;

    public function __construct(SymfonyEvent $event)
    {
        $this->internalEvent = $event;
    }

    public function getWorkflowEvent(): SymfonyEvent
    {
        return $this->internalEvent;
    }

    public function getMarking(): Marking
    {
        return $this->getWorkflowEvent()->getMarking();
    }

    public function getSubject(): object
    {
        return $this->getWorkflowEvent()->getSubject();
    }

    public function getTransition(): Transition
    {
        return $this->getWorkflowEvent()->getTransition();
    }

    public function getWorkflow(): WorkflowInterface
    {
        return $this->getWorkflowEvent()->getWorkflow();
    }

    public function getWorkflowName(): string
    {
        return $this->getWorkflowEvent()->getWorkflowName();
    }

    /**
     * @param string $key
     * @param mixed $subject
     * @return mixed
     */
    public function getMetadata(string $key, $subject)
    {
        return $this->getWorkflowEvent()->getMetadata($key, $subject);
    }
}
